// RendererOGL.cpp: implementation of the CRendererOGL class.
//
// created by Unwinder
//////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "RendererOGL.h"
//////////////////////////////////////////////////////////////////////
CRendererOGL::CRendererOGL()
{
	m_hWnd		= NULL;
	m_hContext	= NULL;
}
//////////////////////////////////////////////////////////////////////
CRendererOGL::~CRendererOGL()
{
	Uninit();
}
//////////////////////////////////////////////////////////////////////
BOOL CRendererOGL::Init(HWND hWnd)
{
	Uninit();

	m_hWnd = hWnd;

	PIXELFORMATDESCRIPTOR pfd;
	ZeroMemory(&pfd, sizeof(pfd));

	pfd.nSize		= sizeof(pfd);
	pfd.nVersion	= 1;
	pfd.dwFlags		= PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_SUPPORT_COMPOSITION | PFD_DOUBLEBUFFER;
	pfd.iPixelType	= PFD_TYPE_RGBA;
	pfd.cColorBits	= 32;
	pfd.cAlphaBits	= 8;
	pfd.iLayerType	= PFD_MAIN_PLANE;

	HDC hDC = GetDC(m_hWnd);

	if (hDC)
	{
		int nFormat = ChoosePixelFormat(hDC, &pfd);

		if (nFormat)
		{
			if (SetPixelFormat(hDC, nFormat, &pfd))
			{
				m_hContext = wglCreateContext(hDC);

				if (m_hContext)
					wglMakeCurrent(hDC, m_hContext);
			}
		}

		ReleaseDC(m_hWnd, hDC);
	}

	return (m_hContext != NULL);
}
//////////////////////////////////////////////////////////////////////
void CRendererOGL::Uninit()
{
	if (m_hContext)
	{
		HDC hDC = GetDC(m_hWnd);

		if (hDC)
		{
			wglMakeCurrent(hDC, NULL);
			wglDeleteContext(m_hContext);

			m_hContext = NULL;

			ReleaseDC(m_hWnd, hDC);
		}
	}
}
//////////////////////////////////////////////////////////////////////
void CRendererOGL::Reset(int x, int y)
{
}
//////////////////////////////////////////////////////////////////////
void CRendererOGL::Render(DWORD dwColor)
{
	HDC hDC = GetDC(m_hWnd);

	if (hDC)
	{
		CRect cr;
		GetClientRect(m_hWnd, &cr);

		glViewport(0, 0, cr.Width(), cr.Height());
		glClearColor((dwColor & 0xFF) / 255.0f, ((dwColor>>8) & 0xFF) / 255.0f, ((dwColor>>16) & 0xFF) / 255.0f, ((dwColor>>24) & 0xFF) / 255.0f);
		glClear(GL_COLOR_BUFFER_BIT);

		SwapBuffers(hDC);

		ReleaseDC(m_hWnd, hDC);
	}
}
//////////////////////////////////////////////////////////////////////
